/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.replace;

import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.panel.PBCommonInfoCenterEnclosureSupport;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterEnclosureSupport;
import com.ibm.hwmca.xfw.service.serviceaction.DefaultServiceAction;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PIReplaceEnclosure
extends DefaultServiceAction {
    private static final String TRACE_MASKT = "XRVPEE_T";
    private static final String TRACE_MASKF = "XRVPEE_F";
    private static final String TRACE_MASKD = "XRVPEE_D";

    public PIReplaceEnclosure() {
        Trace.trace(TRACE_MASKT, "<> PIReplaceEnclosure default ctor");
    }

    public PIReplaceEnclosure(PersistentData persistentData) throws ServiceActionException {
        super(persistentData);
        Trace.trace(TRACE_MASKT, "<> PIReplaceEnclosure persistent data ctor. persistentData: " + persistentData);
    }

    /*
     * Loose catch block
     */
    public void start(Map userData) throws ServiceActionException {
        block15: {
            block14: {
                String hmcIPAddress;
                Trace.trace(TRACE_MASKT, "-> PIReplaceEnclosure.start");
                GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                PBCommonInfoCenterEnclosureSupport bean = new PBCommonInfoCenterEnclosureSupport();
                bean = (PBCommonInfoCenterEnclosureSupport)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData);
                if (bean.isSecondRadioButtonSelected()) {
                    Trace.trace(TRACE_MASKF, "PIReplaceEnclosure.start user selected to delay....");
                    break block14;
                }
                Locale clientLocale = Locale.US;
                try {
                    hmcIPAddress = this.getHMCIpAddr();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "PIReplaceEnclosure.start exception caught getting hmc ip addres; using 127.0.0.1");
                    hmcIPAddress = "127.0.0.1";
                }
                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                ExternalDataAccess eda = null;
                try {
                    ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
                    if (edaf == null) {
                        Trace.trace(TRACE_MASKT, "<-! PIReplaceEnclosure.start ExternalDataAccessFactory not set in userData");
                        throw new ServiceActionException("ExternalDataAccessFactory not set in userData");
                    }
                    eda = edaf.create(null);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! PIReplaceEnclosure.start undable to create ExternalDataAccess, exception=" + e);
                    Trace.trace(TRACE_MASKT, e);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("EXTERNAL_DATA_ACCESS", eda);
                map.put("HMC_HOSTNAME", hmcIPAddress);
                eda.setToken((Serializable)((Object)PIReplaceEnclosure.makeInfoCenterURL("selectmodel", hmcIPAddress, clientLocale)));
                PBCommonPostInfoCenterEnclosureSupport returnPanelBean = new PBCommonPostInfoCenterEnclosureSupport();
                returnPanelBean.setDataMap(map);
                guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", returnPanelBean.getTemplateName(), returnPanelBean, userData);
            }
            Object var11_13 = null;
            try {
                ProblemManager.getProblemManager().close((Problem)userData.get("SERVICEABLE_EVENT"));
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "PIReplaceEnclosure.start exception caught closing associated problem - ignoring [" + e + "]");
            }
            break block15;
            {
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "<-! PIReplaceEnclosure.start exception caught: " + e);
                    Trace.trace(TRACE_MASKF, e);
                    if (e instanceof ServiceActionException) {
                        throw (ServiceActionException)e;
                    }
                    throw new ServiceActionException(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    ProblemManager.getProblemManager().close((Problem)userData.get("SERVICEABLE_EVENT"));
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "PIReplaceEnclosure.start exception caught closing associated problem - ignoring [" + e + "]");
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIReplaceEnclosure.start");
    }

    protected static String makeInfoCenterURL(String infoCenterFileName, String ipaddr, Locale locale) {
        Trace.trace(TRACE_MASKT, "-> PIReplaceEnclosure.makeURL (locale=" + locale + ")");
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/iphaj/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/iphaj/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace(TRACE_MASKF, "PIReplaceEnclosure.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        String retUrl = "http://" + ipaddr + correctUrl + infoCenterFileName + ".htm";
        Trace.trace(TRACE_MASKT, "<- PIReplaceEnclosure.makeURL: " + retUrl);
        return retUrl;
    }

    protected String getHMCIpAddr() throws Exception {
        String ipaddr;
        block7: {
            Trace.trace(TRACE_MASKT, "-> PIReplaceEnclosure.getHMCIpAddr");
            ipaddr = null;
            String toms_hn = null;
            String name = null;
            String domain = null;
            try {
                ipaddr = InetAddress.getLocalHost().getHostAddress();
                if (ipaddr != null) {
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from getHostAddress() call is <" + ipaddr + ">");
                    break block7;
                }
                Trace.trace(TRACE_MASKF, "-- HMC hostname returned is null, trying alternate hostname...");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "-- NetworkSettings exception is " + e + ", rethrowing...");
                    throw e;
                }
            }
            catch (UnknownHostException uhe) {
                Trace.trace(TRACE_MASKF, "-- caught unknown host exception, try alternate call...>");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace(TRACE_MASKF, "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "-- NetworkSettings exception is " + e);
                    throw e;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIReplaceEnclosure.getHMCIpAddr");
        return ipaddr;
    }
}

